<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ta1="http://www.sec.gov/edgar/ta/taonefiler">

	<xsl:template name="item2_independentRegistrantInfo"
		match="ta1:independentRegistrant">
		<h1>
			<xsl:value-of select="$submissionType" />
			: Independent, Non-Issuer Registrant Information
		</h1>
		
		<p>
          <b>
				Completion of Question 8 on this form is required
				by all independent, non-issuer registrants whose appropriate
				regulatory authority is the Securities and Exchange Commission.
				Those registrants who are not required to complete Question 8
				should select "Not Applicable".
          </b>
      </p>

		<table role="presentation" class="independentRegistrant">
			<tr>
				<td class="label">
					<font color="black">
						<b>8. </b>
						Is registrant a:
					</font>
				</td>
				<xsl:choose>
					<xsl:when test="ta1:formData/ta1:independentRegistrant/ta1:registrantType='Other'">
						<td style="width: 60px">
							<div class="fakeBox2">
								<xsl:value-of select="ta1:formData/ta1:independentRegistrant/ta1:registrantType" />
							</div>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="ta1:formData/ta1:independentRegistrant/ta1:registrantTypeDescription" />
							</div>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="ta1:formData/ta1:independentRegistrant/ta1:registrantType" />
							</div>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
		</table>	
			<xsl:choose>
				<xsl:when
					test="ta1:formData/ta1:independentRegistrant/ta1:registrantType='Corporation' or ta1:formData/ta1:independentRegistrant/ta1:registrantType='Partnership'">
                    <p>
								Section for Initial Registration and for Amendments
								Reporting Additional Persons.
                    </p>
					<xsl:for-each select="ta1:formData/ta1:independentRegistrant/ta1:corporationPartnershipData">
						<xsl:call-template name="mode_corporationPartnershipData" />
					</xsl:for-each>
				</xsl:when>
				<xsl:when
					test="ta1:formData/ta1:independentRegistrant/ta1:registrantType='Sole Proprietorship' or ta1:formData/ta1:independentRegistrant/ta1:registrantType='Other'">
							<p>Section for Initial Registration and for Amendments
								Reporting Additional Persons.
                     </p>
					<xsl:for-each select="ta1:formData/ta1:independentRegistrant/ta1:soleProprietorshipOtherData">
						<xsl:call-template name="mode_soleProprietorshipOtherData" />
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>
         <p>
		      <b>9.</b> Does any person or entity not named in the answer to Question 8:
			</p>
		 	<table role="presentation">	
				<tr>
					<td class="label">
						<font face="Times New Roman">
							<b>9(a). </b>
						</font>
	               directly or indirectly, through agreement or otherwise exercise or 
	               have the power to exercise control over the management or policies of applicant, or;….
					</td>
					<td>					
							<xsl:choose>
								<xsl:when test="ta1:formData/ta1:independentRegistrant/ta1:otherControlManagement/ta1:otherEntity = 'Y'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							&#160;Yes&#160;
							<xsl:choose>
								<xsl:when test="ta1:formData/ta1:independentRegistrant/ta1:otherControlManagement/ta1:otherEntity = 'N'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							&#160;No
					</td>
				</tr>
			</table>
			<table>
				<xsl:if test="ta1:formData/ta1:independentRegistrant/ta1:otherControlManagement/ta1:otherEntity='Y'">
	
					<xsl:for-each
						select="ta1:formData/ta1:independentRegistrant/ta1:otherControlManagement/ta1:otherControlManagementDetails">
						<xsl:call-template name="mode_otherControlManagementDetails" />
					</xsl:for-each>
	
				</xsl:if>
			</table>
			
			<table role="presentation">	
				<tr>
					<td class="label">
						<font face="Times New Roman">
							<b>9(b). </b>
						</font>
	                 wholly or partially finance the business of the applicant, 
	                 directly or indirectly, in any manner other than by a public 
	                 offering of securities made pursuant to the Securities Act of 1933 
	                 or by credit extended in the ordinary course of business by suppliers, banks and others?…..
					</td>
					<td>
							<xsl:choose>
								<xsl:when test="ta1:formData/ta1:independentRegistrant/ta1:otherControlFinance/ta1:otherEntity = 'Y'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							&#160;Yes&#160;
							<xsl:choose>
								<xsl:when test="ta1:formData/ta1:independentRegistrant/ta1:otherControlFinance/ta1:otherEntity = 'N'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							&#160;No
					</td>
				</tr>
			</table>
			<table>
				<xsl:if test="ta1:formData/ta1:independentRegistrant/ta1:otherControlFinance/ta1:otherEntity='Y'">
					<xsl:for-each
						select="ta1:formData/ta1:independentRegistrant/ta1:otherControlFinance/ta1:otherControlFinanceDetails">
						<xsl:call-template name="mode_otherControlFinanceDetails" />
					</xsl:for-each>
				</xsl:if>
			</table>
			
	</xsl:template>
	<xsl:template name="mode_corporationPartnershipData">
         <p></p>
				corporation or partner information Related to item 8 Record:
				<xsl:value-of select="position()" />
	<table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(i). </b>
				</font>
				Full Name
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(ii). </b>
				</font>
				Relationship Start Date
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:relationshipStartDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(iii). </b>
				</font>
				Title or Status
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:titleOrStatus" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(iv). </b>
				</font>
				Ownership Code
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:ownershipCode" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(v). </b>
				</font>
				Control Person
			</td>
			<td>
					<xsl:choose>
						<xsl:when test="ta1:controlPerson = 'true'">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					&#160;Yes&#160;
			</td>
		</tr>
		<xsl:if test="$submissionType='TA-1/A'">
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>8(a)(vi). </b>
					</font>
					Relationship End Date
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="ta1:relationshipEndDate" />
					</div>
				</td>
			</tr>
		</xsl:if>
	</table>	
	</xsl:template>
	<xsl:template name="mode_soleProprietorshipOtherData">
      <p>
			Proprietor or other entity information Related to item 8 Record:
				<xsl:value-of select="position()" />
		</p>
		<table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(i). </b>
				</font>
				Full Name
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(ii). </b>
				</font>
				Relationship Start Date
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:relationshipStartDate" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(iii). </b>
				</font>
				Title or Status
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:titleOrStatus" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>8(a)(iv). </b>
				</font>
				Description of Authority
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:authorityDescription" />
				</div>
			</td>
		</tr>
		<xsl:if test="$submissionType='TA-1/A'">
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>8(a)(v). </b>
					</font>
					Relationship End Date
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="ta1:relationshipEndDate" />
					</div>
				</td>
			</tr>
		</xsl:if>
	</table>
	</xsl:template>

	<xsl:template name="mode_otherControlManagementDetails">
         <p>
				Entity information Related to item 9(a)
				Record:
				<xsl:value-of select="position()" />
			</p>
		<table role="presentation">		
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>9(a)(i). </b>
				</font>
				Exact name of each person or entity:
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>9(a)(ii). </b>
				</font>
				Description of the Agreement or other basis:
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:agreementDescription" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
	<xsl:template name="mode_otherControlFinanceDetails">
         <p>
				Entity information Related to item 9(b)
				Record:
				<xsl:value-of select="position()" />
			</p>
    <table role="presentation">
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>9(b)(i). </b>
				</font>
				Exact name of each person or entity:
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>9(b)(ii). </b>
				</font>
				Description of the Agreement or other basis:
			</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="ta1:agreementDescription" />
				</div>
			</td>
		</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>